/**
 * Initialize page js before it gets visible
 *
 * Called on page load and everytime we load a page through AJAX (before we show the loaded content)
 * IMPORTANT: use "context" variable in the calls to jQuery inside this function,
 * such that it's new call doesn't conflict with the old one (e.g. when we first load the page) + performance optimization
 */
function dm3_page_initialize($, context) {

  "use strict";

  /**
   * Dm3Rs Slider
   */
  $('#dm3-rs', context).dm3Rs();

  /**
   * Flexslider
   */
  $('.flexslider', context).each(function() {
    var slider = $(this);
    var args = null;

    var w = slider.data('width');
    var h = slider.data('height');

    if (w && h) {
      var ratio = h / w;
      slider.find('> .slides').css('height', (slider.width() * ratio) + 'px');
    }

    if (slider.hasClass('flexslider-posts')) {
      args = {
        animation: 'slide',
        animationLoop: true,
        slideshow: true,
        itemWidth: 335,
        itemMargin: 20,
        prevText: '<span></span>',
        nextText: '<span></span>'
      };
    } else if (slider.hasClass('flexslider-logos')) {
      args = {
        animation: 'slide',
        animationLoop: false,
        slideshow: false,
        itemWidth: 280,
        itemMargin: 0,
        prevText: '<span></span>',
        nextText: '<span></span>'
      };
    } else {
      args = {
        animation: 'slide',
        easing: 'easeInOutExpo',
        slideshow: true,
        prevText: '<span></span>',
        nextText: '<span></span>',
        smoothHeight: true,
        video: true
      };

      var autoscroll = parseInt(slider.data('autoscroll'), 10);

      if (!isNaN(autoscroll) && autoscroll > 0) {
        args.slideshow = true;
        args.slideshowSpeed = autoscroll * 1000;
      }

      var animation = slider.data('animation');

      if (animation) {
        args.animation = animation;
        args.easing = 'swing';
      }
    }

    if (slider.hasClass('direction-nav-hidden')) {
      args.directionNav = false;
    }

    args.start = function(slider) {
      slider.find('> .flex-viewport > .slides').css('height', 'auto');
    };

    slider.flexslider(args);
  });

  /**
   * Portfolio (Gallery)
   */
  $('.dm3-gallery', context).each(function() {
    var gallery = $(this);

    // Isotope
    setTimeout(function() {
      gallery.isotope({
        itemSelector: 'li',
        layoutMode: 'fitRows'
      });
    }, 200);

    // Magnific Popup
    gallery.magnificPopup({
      delegate: '.mfp-image, .mfp-iframe',
      type: 'image',
      titleSrc: 'title',
      gallery: {
        enabled: false
      }
    });

    gallery.find('> li').hover(function() {
      var li = $(this);
      var desc = li.find('.dm3-gallery-popover:first');
      desc.stop().css({opacity: 0, display: 'block'}).animate({opacity: 1}, {duration: 200});
    }, function() {
      var li = $(this);
      var desc = li.find('.dm3-gallery-popover:first');
      desc.stop().animate({opacity: 0}, {duration: 200, complete: function() {
        $(this).css('display', 'none');
      }});
    });

    // Terms filter
    var terms = gallery.prev('.dm3-gallery-terms');
    terms.find('a').on('click', function(e) {
      var a = $(this);
      var filter = a.data('filter');
      e.preventDefault();
      gallery.isotope({
        filter: filter
      });
      a.parent().siblings().removeClass('active');
      a.parent().addClass('active');
    });
  });

  /**
   * Flexslider posts
   */
  $('.flexslider-posts .slides > li, .dm3-member-block').hover(function() {
    $(this).find('> .image, > .dm3-member-image').stop().animate({opacity: 0.6}, {duration: 300});
  }, function() {
    $(this).find('> .image, > .dm3-member-image').stop().animate({opacity: 1}, {duration: 300});
  });

  /**
   * Shortcodes
   */
  if (typeof dm3_shortcodes_init === 'function') {
    dm3_shortcodes_init(context);
  }

  /**
   * Footer
   */
  $('#footer-back-to-top', context).on('click', function(e) {
    e.preventDefault();
    $('body, html').animate({scrollTop: 0}, {duration: 500, easing: 'easeOutExpo'});
  });

  /**
   * Magnific popup
   */
  $('a.dm3-lightbox', context).magnificPopup({
    type: 'image',
    titleSrc: 'title',
    gallery: {
      enabled: false
    }
  });

  /**
   * Google map
   */
  $('.google-map', context).each(function() {
    if (typeof google === 'undefined') {
      return;
    }

    var map_div = $(this);
    var lat = map_div.data('latitude');
    var lng = map_div.data('longitude');
    var win = $(window);
    var lat_lng = new google.maps.LatLng(lat, lng);
    var map = new google.maps.Map(map_div.get(0), {
      zoom: 15,
      scrollwheel: true,
      streetViewControl: true,
	  showTool:true,
      zoomControl: true,
      mapTypeId: google.maps.MapTypeId.ROADMAP,
      center: lat_lng
    });
    
    var offset_map = function() {
      var offsetx = 200;
      var offsety = -50;

      var point1 = map.getProjection().fromLatLngToPoint(lat_lng);
      var point2 = new google.maps.Point(offsetx / Math.pow(2, map.getZoom()) || 0, offsety / Math.pow(2, map.getZoom()) || 0);
      map.setCenter(map.getProjection().fromPointToLatLng(new google.maps.Point(point1.x - point2.x, point1.y + point2.y)));
    };
    
    if (map.getProjection()) {
      offset_map();
    } else {
      google.maps.event.addListener(map, 'projection_changed', offset_map);
    }

    new google.maps.Marker({
      position: lat_lng,
      map: map,
      icon: 'images/map-marker.png'
    });

    var resize_to = null;

    win.resize(function() {
      if (resize_to) {
        clearTimeout(resize_to);
        resize_to = null;
      }

      resize_to = setTimeout(function() {
        offset_map();
      }, 500);
    });
  });

  /**
   * Placeholders in ie
   */
  if (!('placeholder' in document.createElement('input'))) {
    $('input, textarea', context).each(function() {
      var _this = $(this);
      var placeholder_val = _this.attr('placeholder');

      if (placeholder_val && !_this.val()) {
        _this.addClass('input-placeholder');
        _this.val(placeholder_val);
      }

      _this.on('focus', function() {
        if (_this.val() === placeholder_val) {
          _this.val('');
          _this.removeClass('input-placeholder');
        }
      });

      _this.on('blur', function() {
        if (!_this.val()) {
          _this.val(placeholder_val);
          _this.addClass('input-placeholder');
        }
      });
    });
  }

  /**
   * Escape html string, so that it is not parsed as HTML
   */
  function dm3_escape_html(str) {
    return str
      .replace(/&/g, "&amp;")
      .replace(/</g, "&lt;")
      .replace(/>/g, "&gt;")
      .replace(/"/g, "&quot;")
      .replace(/'/g, "&#039;");
  }

  /**
   * Contact form
   */
  function dm3_contact_form(selector) {
    // Updates security question  
    var update_s_q = function(s_q) {
      $.get('scripts/contact/captcha_question.php', function(response) {
        s_q.closest('.form-1-field').find('label:first span:first').html(response);
        s_q.val('');
        s_q.focus();
      });
    };

    $(selector, context).each(function() {
      var form = $(this);
      form.find('.dm3-alert-success, .dm3-alert-error').hide();
      form.find('#s_q_change').on('click', function(e) {
        e.preventDefault();
        update_s_q(form.find('[name="s_q"]'));
      });
    });

    $(selector, context).submit(function(e) {
      e.preventDefault();

      var form = $(this),
          button = $('#contact-submit', context),
          ajax_loader = form.find('div.ajax-loader:first');

      if (!ajax_loader.length) {
        ajax_loader = $('<div class="ajax-loader"></div>').insertAfter(button);
      } else {
        ajax_loader.fadeIn();
      }

      button.addClass('disabled');
      button.attr('disabled', 'disabled');
      form.find('.dm3-alert-success, .dm3-alert-error').fadeOut();

      var first_name = form.find('[name="first_name"]'),
          last_name = form.find('[name="last_name"]'),
          email = form.find('[name="email"]'),
          phone = form.find('[name="phone"]'),
          subject = form.find('[name="subject"]'),
          message = form.find('[name="message"]'),
          s_q = form.find('[name="s_q"]');

      var error = false;

      if (first_name.hasClass('required') && first_name.val() === '') {
        first_name.closest('.form-1-field').addClass('error');
        error = true;
      } else {
        first_name.closest('.form-1-field').removeClass('error');
      }

      if (last_name.hasClass('required') && last_name.val() === '') {
        last_name.closest('.form-1-field').addClass('error');
        error = true;
      } else {
        last_name.closest('.form-1-field').removeClass('error');
      }

      if (email.hasClass('required') && !(email.val()).match(/^([a-z0-9_\.-]+)@([\da-z\.-]+)\.([a-z]{2,6})$/g)) {
        email.closest('.form-1-field').addClass('error');
        error = true;
      } else {
        email.closest('.form-1-field').removeClass('error');
      }

      if (phone.hasClass('required') && phone.val() === '') {
        phone.closest('.form-1-field').addClass('error');
        error = true;
      } else {
        phone.closest('.form-1-field').removeClass('error');
      }

      if (subject.hasClass('required') && subject.val() === '') {
        subject.closest('.form-1-field').addClass('error');
        error = true;
      } else {
        subject.closest('.form-1-field').removeClass('error');
      }

      if (message.hasClass('required') && message.val() === '') {
        message.closest('.form-1-field').addClass('error');
        error = true;
      } else {
        message.closest('.form-1-field').removeClass('error');
      }

      if (s_q.length && s_q.val() === '') {
        s_q.closest('.form-1-field').addClass('error');
        error = true;
      } else if (s_q.length) {
        s_q.closest('.form-1-field').removeClass('error');
      }

      if (error) {
        ajax_loader.fadeOut();
        button.removeClass('disabled').removeAttr('disabled');
        return false;
      }

      var data = {
        'is_ajax': 1,
        'first_name': first_name.val(),
        'last_name': last_name.val(),
        'email': email.val(),
        'phone': phone.val(),
        'subject': subject.val(),
        'message': message.val()
      };

      if (s_q.length) {
        data.s_q = s_q.val();
      }

      $.ajax({
        url: 'scripts/contact/process.php',
        type: 'post',
        data: data,
        success: function(response) {
          ajax_loader.fadeOut();
          button.removeClass('disabled').removeAttr('disabled');

          if (response === '1') {
            update_s_q(s_q);
            form.find('.form-1-field').removeClass('error');
            form.find('input[type="text"], textarea, select').val('');
            form.find('.dm3-alert-error:first').fadeOut();
            form.find('.dm3-alert-success:first').fadeIn();
          } else {
            switch (response) {
              case 'file_count not writable':
              case 'file_ips not writable':
                alert(response);
                break;

              case 's_q':
                s_q.closest('.form-1-field').addClass('error');
                break;

              default:
                if (response !== '') {
                  form.find('.dm3-alert-error:first').text(dm3_escape_html(response)).fadeIn();
                } else {
                  form.find('.dm3-alert-error:first').text('Error. Please try again.').fadeIn();
                }

                update_s_q(s_q);
                form.find('.dm3-alert-success:first').fadeOut();
            }
          }
        }
      });
    });
  }

  dm3_contact_form('#contact-form');
}

jQuery(window).load(function() {
  dm3_page_initialize(jQuery, null);
});